HelicopterInputEvent = {}
local HelicopterInputEvent_mt = Class(HelicopterInputEvent, Event)

InitEventClass(HelicopterInputEvent, "HelicopterInputEvent")

function HelicopterInputEvent.emptyNew()
    return Event.new(HelicopterInputEvent_mt)
end

function HelicopterInputEvent.new(vehicle, inputW, inputS, inputA, inputD, leftMouse, rightMouse)
    local self = HelicopterInputEvent.emptyNew()
    self.vehicle = vehicle
    self.inputW = inputW
    self.inputS = inputS
    self.inputA = inputA
    self.inputD = inputD
    self.leftMouse = leftMouse
    self.rightMouse = rightMouse
    return self
end

function HelicopterInputEvent:readStream(streamId, connection)
    local vehicleId = streamReadInt32(streamId)
    self.vehicle = NetworkUtil.getObject(vehicleId)
    self.inputW = streamReadBool(streamId)
    self.inputS = streamReadBool(streamId)
    self.inputA = streamReadBool(streamId)
    self.inputD = streamReadBool(streamId)
    self.leftMouse = streamReadBool(streamId)
    self.rightMouse = streamReadBool(streamId)
    self:run(connection)
end

function HelicopterInputEvent:writeStream(streamId, connection)
    streamWriteInt32(streamId, NetworkUtil.getObjectId(self.vehicle))
    streamWriteBool(streamId, self.inputW or false)
    streamWriteBool(streamId, self.inputS or false)
    streamWriteBool(streamId, self.inputA or false)
    streamWriteBool(streamId, self.inputD or false)
    streamWriteBool(streamId, self.leftMouse or false)
    streamWriteBool(streamId, self.rightMouse or false)
end

function HelicopterInputEvent:run(connection)
    if not connection:getIsServer() then
        g_server:broadcastEvent(HelicopterInputEvent.new(self.vehicle, self.inputW, self.inputS, self.inputA, self.inputD, self.leftMouse, self.rightMouse), nil, connection, self.vehicle)
    end

    if self.vehicle ~= nil and self.vehicle.setHelicopterInput ~= nil then
        self.vehicle:setHelicopterInput(self.inputW, self.inputS, self.inputA, self.inputD, self.leftMouse, self.rightMouse)
    end
end
