HelicopterMode = {}

function HelicopterMode.prerequisitesPresent(specializations)
    return true
end

function HelicopterMode.registerEventListeners(vehicleType)
    SpecializationUtil.registerEventListener(vehicleType, "onLoad", HelicopterMode)
    SpecializationUtil.registerEventListener(vehicleType, "onUpdate", HelicopterMode)
    SpecializationUtil.registerEventListener(vehicleType, "onDraw", HelicopterMode)
end

function HelicopterMode:onLoad(savegame)
    self.heli_isFlying = false
    self.heli_hasLifted = false
    self.heli_liftForce = 80
    self.heli_gravityForce = -1
    self.heli_forwardForce = 638
    self.heli_hoverForce = 24

    self.setHelicopterInput = HelicopterMode.setHelicopterInput

    self.heli_inputW = false
    self.heli_inputS = false
    self.heli_inputA = false
    self.heli_inputD = false
    self.heli_inputLMB = false
    self.heli_inputRMB = false

    self.lastInputW = false
    self.lastInputS = false
    self.lastInputA = false
    self.lastInputD = false
    self.lastInputLMB = false
    self.lastInputRMB = false

    self.showLowSpeedWarning = false

    self.heli_currentForward = 0
    self.heli_accelerationRate = 2.0 -- egység per másodperc

  
end

function HelicopterMode:setHelicopterInput(w, s, a, d, lmb, rmb)
    self.heli_inputW = w
    self.heli_inputS = s
    self.heli_inputA = a
    self.heli_inputD = d
    self.heli_inputLMB = lmb
    self.heli_inputRMB = rmb
end

function HelicopterMode:onUpdate(dt, isActiveForInput, isActiveForInputIgnoreSelection, isSelected)
    if self:getIsControlled() then
        if self.isClient and self:getIsActiveForInput(true) then
            local w = Input.isKeyPressed(Input.KEY_w)
            local s = Input.isKeyPressed(Input.KEY_s)
            local a = Input.isKeyPressed(Input.KEY_a)
            local d = Input.isKeyPressed(Input.KEY_d)
            local lmb = Input.isMouseButtonPressed(Input.MOUSE_BUTTON_LEFT)
            local rmb = Input.isMouseButtonPressed(Input.MOUSE_BUTTON_RIGHT)

            if self.lastInputW ~= w or self.lastInputS ~= s or self.lastInputA ~= a or self.lastInputD ~= d
                or self.lastInputLMB ~= lmb or self.lastInputRMB ~= rmb then

                self.lastInputW = w
                self.lastInputS = s
                self.lastInputA = a
                self.lastInputD = d
                self.lastInputLMB = lmb
                self.lastInputRMB = rmb

                g_client:getServerConnection():sendEvent(HelicopterInputEvent.new(self, w, s, a, d, lmb, rmb))
            end
        end

        if self.isServer then
            local comp = self.components[1].node
            local speed = self:getLastSpeed() * 3.6
            local upForce = 0
            self.showLowSpeedWarning = false

            if self.heli_inputRMB then
                upForce = self.heli_gravityForce
            elseif self.heli_inputLMB then
                if speed >= 270 then
                    upForce = self.heli_liftForce
                    self.heli_hasLifted = true
                else
                    self.showLowSpeedWarning = true
                end
            elseif self.heli_hasLifted then
                upForce = self.heli_hoverForce
            end

            -- Gyorsulás kiszámítása
            local acceleration = self.heli_accelerationRate * dt / 16.666
            if self.heli_inputW then
                self.heli_currentForward = math.min(self.heli_forwardForce, self.heli_currentForward + acceleration)
            elseif self.heli_inputS then
                self.heli_currentForward = math.max(-self.heli_forwardForce, self.heli_currentForward - acceleration)
            else
                if self.heli_currentForward > 0 then
                    self.heli_currentForward = math.max(0, self.heli_currentForward - acceleration)
                elseif self.heli_currentForward < 0 then
                    self.heli_currentForward = math.min(0, self.heli_currentForward + acceleration)
                end
            end

            -- Előreirányú mozgás irány alapján
            local dx, _, dz = localDirectionToWorld(comp, 1, 0, 0)
            local sinDir = dx / 15
            local cosDir = dz / -15
            local moveSpeed = self.heli_currentForward
            local xForce = moveSpeed * cosDir
            local zForce = moveSpeed * sinDir

            -- Hullámmozgás emeléshez
            local time = g_currentMission.time / 1000
            local wave = math.sin(time * 1.5) * 5
            local fy = upForce + wave

            if moveSpeed ~= 0 or upForce ~= 0 then
                addForce(comp, xForce, fy, zForce, 0, 0, 0, true)
            end

            self.heli_isFlying = upForce > 0

            local yawTorque = 0
            if self.heli_inputA then
                yawTorque = 90
            elseif self.heli_inputD then
                yawTorque = -90
            end
            if yawTorque ~= 0 then
                addTorque(comp, 0, yawTorque, 0, true)
            end

            setLinearDamping(comp, 0.33)
            setAngularDamping(comp, 0.99)
        end
    end
end

function HelicopterMode:onDraw()
    if self:getIsControlled() and self.showLowSpeedWarning then
        setTextColor(1, 0.2, 0.2, 1)
        setTextBold(true)
        setTextAlignment(RenderText.ALIGN_CENTER)
        renderText(0.5, 0.05, 0.025, g_i18n:getText("warning_lowHeliSpeed"))
        setTextBold(false)
        setTextAlignment(RenderText.ALIGN_LEFT)
        setTextColor(1, 1, 1, 1)
    end

    if self.components ~= nil and self.components[1] ~= nil then
        local px, py, pz = getWorldTranslation(self.components[1].node)
        local groundY = getTerrainHeightAtWorldPos(g_currentMission.terrainRootNode, px, 0, pz)
        local relativeHeight = math.max(0, py - groundY)
        local height = string.format("%.1f", relativeHeight)
        local label = g_i18n:getText("heli_heightText")
        setTextColor(1, 1, 0, 1)
        setTextBold(false)
        setTextAlignment(RenderText.ALIGN_CENTER)
        renderText(0.5, 0.02, 0.02, label .. ": " .. height .. " m")
        setTextAlignment(RenderText.ALIGN_LEFT)
        setTextColor(1, 1, 1, 1)
    end 
end
